<?php
require_once __DIR__ . '/header.php';
requireSuperadmin();

// Cargar todas las vacantes con empresa
$sql = "SELECT v.*, e.nombre AS empresa
        FROM vacantes v
        LEFT JOIN empresas e ON e.id = v.empresa_id
        ORDER BY v.created_at DESC";

$vacantes = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);
?>

<h1 class="h4 mb-4">Todas las Vacantes</h1>

<div class="card bg-dark border-secondary p-3">
<table class="table table-dark table-hover align-middle">
    <thead>
        <tr>
            <th>Empresa</th>
            <th>Título</th>
            <th>Ubicación</th>
            <th>Modalidad</th>
            <th>Tipo</th>
            <th>Estado</th>
            <th>Creada</th>
            <th>Acciones</th>
        </tr>
    </thead>

    <tbody>
        <?php foreach ($vacantes as $v): ?>
            <tr>
                <td><?= h($v['empresa']); ?></td>
                <td><?= h($v['titulo']); ?></td>
                <td><?= h($v['ubicacion']); ?></td>
                <td><?= h($v['modalidad']); ?></td>
                <td><?= h($v['tipo']); ?></td>
                <td>
                    <span class="badge bg-<?= $v['estado']=='abierta'?'success':'danger' ?>">
                        <?= h($v['estado']); ?>
                    </span>
                </td>
                <td><?= h($v['created_at']); ?></td>
                <td>
                    <a href="vacante_form.php?id=<?= $v['id']; ?>" class="btn btn-sm btn-primary">Editar</a>
                </td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>
</div>

<?php require_once __DIR__ . '/footer.php'; ?>
