<?php
require_once __DIR__ . '/header.php';

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// VALORES POR DEFECTO
$vacante = [
  'empresa_id' => currentEmpresaId(),
  'titulo'     => '',
  'descripcion'=> '',
  'ubicacion'  => '',
  'modalidad'  => '',
  'tipo'       => '',
  'salario'    => '',
  'estado'     => 'abierta',
  'imagen'     => ''
];

$errorMsg = '';

/* ============================================
   MODO EDICIÓN → Cargar vacante existente
============================================ */
if ($id) {
    $stmt = $pdo->prepare("SELECT * FROM vacantes WHERE id = ?");
    $stmt->execute([$id]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($row) {
        $vacante = $row;
    } else {
        echo '<div class="alert alert-danger">La vacante no existe.</div>';
        require_once __DIR__ . '/footer.php';
        exit;
    }
}

/* ============================================
   LISTA DE EMPRESAS (solo para superadmin)
============================================ */
$empresas = [];
if (isSuperadmin()) {
    $empresas = $pdo->query("SELECT id, nombre FROM empresas ORDER BY nombre ASC")->fetchAll(PDO::FETCH_ASSOC);
}

/* ============================================
   PROCESAR FORMULARIO
============================================ */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Empresa
    if (isSuperadmin()) {
        $empresa_id = (int)($_POST['empresa_id'] ?? 0);
    } else {
        $empresa_id = currentEmpresaId();
    }

    // Campos
    $titulo      = trim($_POST['titulo'] ?? '');
    $descripcion = trim($_POST['descripcion'] ?? '');
    $ubicacion   = trim($_POST['ubicacion'] ?? '');
    $modalidad   = trim($_POST['modalidad'] ?? '');
    $tipo        = trim($_POST['tipo'] ?? '');
    $salario     = trim($_POST['salario'] ?? '');
    $estado      = trim($_POST['estado'] ?? 'abierta');

    // Imagen final (mantiene la actual si no suben nueva)
    $imagenFinal = $vacante['imagen'];

    // SUBIR IMAGEN
    if (!empty($_FILES['imagen']['name'])) {

        $allowed = ['jpg','jpeg','png','webp'];
        $ext = strtolower(pathinfo($_FILES['imagen']['name'], PATHINFO_EXTENSION));

        if (in_array($ext, $allowed)) {

            $uploadDir = __DIR__ . "/uploads/vacantes";

            if (!is_dir($uploadDir)) mkdir($uploadDir, 0775, true);

            $fileName = time() . "_" . preg_replace("/[^a-zA-Z0-9_\.-]/","", $_FILES['imagen']['name']);
            $destino = $uploadDir . "/" . $fileName;

            if (move_uploaded_file($_FILES['imagen']['tmp_name'], $destino)) {
                $imagenFinal = "uploads/vacantes/" . $fileName;
            }
        }
    }

    // Actualizar arreglo para mostrar valores en caso de error
    $vacante = [
      'empresa_id' => $empresa_id,
      'titulo'     => $titulo,
      'descripcion'=> $descripcion,
      'ubicacion'  => $ubicacion,
      'modalidad'  => $modalidad,
      'tipo'       => $tipo,
      'salario'    => $salario,
      'estado'     => $estado,
      'imagen'     => $imagenFinal
    ];

    // Validación mínima
    if (!$empresa_id || !$titulo) {
        $errorMsg = 'Debes capturar la empresa y el título de la vacante.';
    } else {

        /* ============================================
           GUARDAR EN DB
        ============================================ */

        if ($id) {
            // UPDATE
            $stmt = $pdo->prepare("
                UPDATE vacantes SET 
                    empresa_id=?, titulo=?, descripcion=?, ubicacion=?, modalidad=?, 
                    tipo=?, salario=?, estado=?, imagen=?
                WHERE id=?
            ");
            $stmt->execute([
                $empresa_id, $titulo, $descripcion, $ubicacion, $modalidad,
                $tipo, $salario, $estado, $imagenFinal, $id
            ]);

        } else {
            // INSERT
            $stmt = $pdo->prepare("
                INSERT INTO vacantes
                (empresa_id, titulo, descripcion, ubicacion, modalidad, tipo, salario, estado, imagen)
                VALUES (?,?,?,?,?,?,?,?,?)
            ");
            $stmt->execute([
                $empresa_id, $titulo, $descripcion, $ubicacion, $modalidad,
                $tipo, $salario, $estado, $imagenFinal
            ]);
        }

        redirect('admin/vacantes.php');
    }
}
?>

<!-- ============================================
     FORMULARIO HTML COMPLETO
============================================ -->

<h1 class="h4 mb-3"><?php echo $id ? 'Editar vacante' : 'Nueva vacante'; ?></h1>

<?php if ($errorMsg): ?>
  <div class="alert alert-danger"><?php echo h($errorMsg); ?></div>
<?php endif; ?>

<form method="post" enctype="multipart/form-data" class="card card-body bg-dark border-secondary">

  <?php if (isSuperadmin()): ?>
    <div class="mb-3">
      <label class="form-label">Empresa</label>
      <select name="empresa_id" class="form-select" required>
        <option value="">-- Selecciona empresa --</option>
        <?php foreach ($empresas as $e): ?>
          <option value="<?= (int)$e['id']; ?>" <?= $vacante['empresa_id']==$e['id']?'selected':'' ?>>
            <?= h($e['nombre']); ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>
  <?php endif; ?>

  <div class="mb-3">
    <label class="form-label">Título</label>
    <input type="text" name="titulo" class="form-control" required value="<?= h($vacante['titulo']); ?>">
  </div>

  <div class="mb-3">
    <label class="form-label">Descripción</label>
    <textarea name="descripcion" class="form-control" rows="5"><?= h($vacante['descripcion']); ?></textarea>
  </div>

  <div class="row">
    <div class="col-md-4 mb-3">
      <label class="form-label">Ubicación</label>
      <input type="text" name="ubicacion" class="form-control" value="<?= h($vacante['ubicacion']); ?>">
    </div>

    <div class="col-md-4 mb-3">
      <label class="form-label">Modalidad</label>
      <select name="modalidad" class="form-select">
        <option value="">-- Seleccionar --</option>
        <option value="Presencial" <?= $vacante['modalidad']=='Presencial'?'selected':'' ?>>Presencial</option>
        <option value="Híbrido" <?= $vacante['modalidad']=='Híbrido'?'selected':'' ?>>Híbrido</option>
        <option value="Remoto" <?= $vacante['modalidad']=='Remoto'?'selected':'' ?>>Remoto</option>
      </select>
    </div>

    <div class="col-md-4 mb-3">
      <label class="form-label">Tipo de puesto</label>
      <select name="tipo" class="form-select">
        <option value="">-- Seleccionar --</option>
        <option value="Tiempo completo" <?= $vacante['tipo']=='Tiempo completo'?'selected':'' ?>>Tiempo completo</option>
        <option value="Medio tiempo" <?= $vacante['tipo']=='Medio tiempo'?'selected':'' ?>>Medio tiempo</option>
        <option value="Por horas" <?= $vacante['tipo']=='Por horas'?'selected':'' ?>>Por horas</option>
      </select>
    </div>
  </div>

  <div class="mb-3">
    <label class="form-label">Rango salarial</label>
    <input type="text" name="salario" class="form-control" placeholder="$20,000 - $30,000 MXN" value="<?= h($vacante['salario']); ?>">
  </div>

  <div class="mb-3">
    <label class="form-label">Imagen (subir archivo)</label>
    <input type="file" name="imagen" class="form-control" accept="image/*">

    <?php if ($vacante['imagen']): ?>
      <div class="mt-2">
        <small class="text-muted">Imagen actual:</small><br>
        <img src="/<?= h($vacante['imagen']); ?>" style="max-width:150px;border-radius:6px;">
      </div>
    <?php endif; ?>
  </div>

  <div class="mb-3">
    <label class="form-label">Estado</label>
    <select name="estado" class="form-select">
      <option value="abierta" <?= $vacante['estado']=='abierta'?'selected':'' ?>>Abierta</option>
      <option value="cerrada" <?= $vacante['estado']=='cerrada'?'selected':'' ?>>Cerrada</option>
    </select>
  </div>

  <button type="submit" class="btn btn-primary">Guardar</button>
  <a href="vacantes.php" class="btn btn-secondary">Cancelar</a>

</form>

<?php require_once __DIR__ . '/footer.php'; ?>
