<?php
require_once __DIR__ . '/header.php';

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

$vacante = [
  'empresa_id' => currentEmpresaId(),
  'titulo' => '',
  'descripcion' => '',
  'ubicacion' => '',
  'modalidad' => '',
  'tipo' => '',
  'salario' => '',
  'estado' => 'abierta',
  'imagen' => ''
];

// Para que superadmin pueda asignar empresa
$empresas = [];
if (isSuperadmin()) {
    $empresas = $pdo->query("SELECT id, nombre FROM empresas WHERE is_active = 1 ORDER BY nombre")->fetchAll();
}

if ($id) {
    $stmt = $pdo->prepare("SELECT * FROM vacantes WHERE id = ?");
    $stmt->execute([$id]);
    $data = $stmt->fetch();
    if ($data) {
        $vacante = array_merge($vacante, $data);
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isSuperadmin()) {
        $empresa_id = (int)($_POST['empresa_id'] ?? 0);
    } else {
        $empresa_id = currentEmpresaId();
    }

    $titulo = trim($_POST['titulo'] ?? '');
    $descripcion = trim($_POST['descripcion'] ?? '');
    $ubicacion = trim($_POST['ubicacion'] ?? '');
    $modalidad = trim($_POST['modalidad'] ?? '');
    $tipo = trim($_POST['tipo'] ?? '');
    $salario = trim($_POST['salario'] ?? '');
    $estado = trim($_POST['estado'] ?? 'abierta');
    $imagen = trim($_POST['imagen'] ?? '');

    if ($titulo && $empresa_id) {
        if ($id) {
            $stmt = $pdo->prepare("UPDATE vacantes
                SET empresa_id=?, titulo=?, descripcion=?, ubicacion=?, modalidad=?, tipo=?, salario=?, estado=?, imagen=?
                WHERE id=?");
            $stmt->execute([$empresa_id, $titulo, $descripcion, $ubicacion, $modalidad, $tipo, $salario, $estado, $imagen, $id]);
        } else {
            $stmt = $pdo->prepare("INSERT INTO vacantes
                (empresa_id, titulo, descripcion, ubicacion, modalidad, tipo, salario, estado, imagen)
                VALUES (?,?,?,?,?,?,?,?,?)");
            $stmt->execute([$empresa_id, $titulo, $descripcion, $ubicacion, $modalidad, $tipo, $salario, $estado, $imagen]);
        }
        redirect('admin/vacantes.php');
    } else {
        echo '<div class="alert alert-danger">Debes capturar al menos empresa y título.</div>';
    }
}
?>
<h1 class="h4 mb-3"><?php echo $id ? 'Editar vacante' : 'Nueva vacante'; ?></h1>
<form method="post">
  <?php if (isSuperadmin()): ?>
  <div class="mb-3">
    <label class="form-label">Empresa</label>
    <select name="empresa_id" class="form-select" required>
      <option value="">-- Selecciona empresa --</option>
      <?php foreach ($empresas as $e): ?>
        <option value="<?php echo (int)$e['id']; ?>" <?php echo $vacante['empresa_id']==$e['id']?'selected':''; ?>>
          <?php echo h($e['nombre']); ?>
        </option>
      <?php endforeach; ?>
    </select>
  </div>
  <?php endif; ?>

  <div class="mb-3">
    <label class="form-label">Título</label>
    <input type="text" name="titulo" class="form-control" required value="<?php echo h($vacante['titulo']); ?>">
  </div>

  <div class="mb-3">
    <label class="form-label">Descripción</label>
    <textarea name="descripcion" class="form-control" rows="5"><?php echo h($vacante['descripcion']); ?></textarea>
  </div>

  <div class="mb-3">
    <label class="form-label">Ubicación</label>
    <input type="text" name="ubicacion" class="form-control" value="<?php echo h($vacante['ubicacion']); ?>">
  </div>

  <div class="mb-3">
    <label class="form-label">Modalidad</label>
    <input type="text" name="modalidad" class="form-control" placeholder="Presencial, remoto, híbrido" value="<?php echo h($vacante['modalidad']); ?>">
  </div>

  <div class="mb-3">
    <label class="form-label">Tipo de puesto</label>
    <input type="text" name="tipo" class="form-control" placeholder="Tiempo completo, medio tiempo, etc." value="<?php echo h($vacante['tipo']); ?>">
  </div>

  <div class="mb-3">
    <label class="form-label">Salario (texto libre)</label>
    <input type="text" name="salario" class="form-control" value="<?php echo h($vacante['salario']); ?>">
  </div>

  <div class="mb-3">
    <label class="form-label">URL Imagen (opcional)</label>
    <input type="text" name="imagen" class="form-control" value="<?php echo h($vacante['imagen'] ?? ''); ?>">
  </div>

  <div class="mb-3">
    <label class="form-label">Estado</label>
    <select name="estado" class="form-select">
      <option value="abierta" <?php echo $vacante['estado']=='abierta'?'selected':''; ?>>Abierta</option>
      <option value="cerrada" <?php echo $vacante['estado']=='cerrada'?'selected':''; ?>>Cerrada</option>
    </select>
  </div>

  <button type="submit" class="btn btn-primary">Guardar</button>
  <a href="vacantes.php" class="btn btn-secondary">Cancelar</a>
</form>
<?php require_once __DIR__ . '/footer.php'; ?>
