<?php
require_once __DIR__ . '/header.php';
requireSuperadmin();

$sql = "SELECT u.*, e.nombre AS empresa
        FROM users u
        LEFT JOIN empresas e ON e.id = u.empresa_id
        ORDER BY u.created_at DESC";
$users = $pdo->query($sql)->fetchAll();
?>
<h1 class="h4 mb-3">Usuarios</h1>
<a href="user_form.php" class="btn btn-sm btn-primary mb-3">Nuevo usuario</a>
<table class="table table-dark table-sm align-middle">
  <thead>
    <tr>
      <th>ID</th>
      <th>Nombre</th>
      <th>Correo</th>
      <th>Rol</th>
      <th>Empresa</th>
      <th>Activo</th>
      <th></th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($users as $u): ?>
    <tr>
      <td><?php echo (int)$u['id']; ?></td>
      <td><?php echo h($u['nombre']); ?></td>
      <td><?php echo h($u['email']); ?></td>
      <td><?php echo $u['role'] == 1 ? 'Superadmin' : 'Admin empresa'; ?></td>
      <td><?php echo h($u['empresa'] ?? ''); ?></td>
      <td><?php echo $u['is_active'] ? 'Sí' : 'No'; ?></td>
      <td class="text-end">
        <a href="user_form.php?id=<?php echo (int)$u['id']; ?>" class="btn btn-sm btn-outline-light">Editar</a>
      </td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php require_once __DIR__ . '/footer.php'; ?>
