<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../functions.php';
require_once __DIR__ . '/../db.php';

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $pass  = $_POST['password'] ?? '';

    if ($email && $pass) {
        $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ? AND is_active = 1");
        $stmt->execute([$email]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($user && password_verify($pass, $user['password_hash'])) {
            $_SESSION['user'] = [
                'id' => $user['id'],
                'empresa_id' => $user['empresa_id'],
                'nombre' => $user['nombre'],
                'email' => $user['email'],
                'role' => (int)$user['role'],
            ];
            redirect('admin/dashboard.php');
        } else {
            $error = 'Credenciales inválidas.';
        }
    } else {
        $error = 'Debes capturar correo y contraseña.';
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <title>Login | <?php echo APP_NAME; ?></title>
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-dark text-light">
  <div class="container d-flex align-items-center justify-content-center" style="min-height:100vh;">
    <div class="card bg-secondary border-0" style="max-width:420px;width:100%;">
      <div class="card-body p-4">
        <h1 class="h4 mb-3 text-center"><?php echo APP_NAME; ?></h1>
        <p class="text-center text-muted mb-4">Panel administrativo</p>
        <?php if ($error): ?>
          <div class="alert alert-danger py-2"><?php echo h($error); ?></div>
        <?php endif; ?>
        <form method="post">
          <div class="mb-3">
            <label class="form-label">Correo</label>
            <input type="email" name="email" class="form-control" required>
          </div>
          <div class="mb-3">
            <label class="form-label">Contraseña</label>
            <input type="password" name="password" class="form-control" required>
          </div>
          <button class="btn btn-primary w-100" type="submit">Entrar</button>
        </form>
      </div>
    </div>
  </div>
</body>
</html>
