<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../functions.php';
require_once __DIR__ . '/../db.php';

requireLogin();

$user = currentUser();
$empresaNombre = 'Sin empresa';
$empresaColor = '#0d6efd';

if ($user['empresa_id']) {
    $stmtEmp = $pdo->prepare("SELECT nombre, color_primario FROM empresas WHERE id = ?");
    $stmtEmp->execute([$user['empresa_id']]);
    if ($row = $stmtEmp->fetch()) {
        $empresaNombre = $row['nombre'];
        if (!empty($row['color_primario'])) {
            $empresaColor = $row['color_primario'];
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <title><?php echo APP_NAME; ?> | Admin</title>
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>


/* ===============================
   FONDO GENERAL & TEXTO
================================ */
body {
    background-color: #0f1629 !important;
    color: #e6e9f5 !important;
}

/* ===============================
   SIDEBAR MEJORADO
================================ */
.sidebar {
    background: #121a2e !important;
    border-right: 1px solid rgba(255,255,255,0.08);
}

.sidebar a {
    display: block;
    padding: 8px 0;
    color: #cfd6e3 !important;
    text-decoration: none;
    font-size: 15px;
}

.sidebar a:hover {
    color: #ffffff !important;
    font-weight: 500;
}

/* ===============================
   TARJETAS KPI DEL DASHBOARD
================================ */
.dashboard-card {
    background: #1e2a45 !important;
    border-radius: 16px !important;
    padding: 22px !important;
    border: 1px solid rgba(255,255,255,0.07) !important;
    color: #fff !important;
    box-shadow: 0 6px 22px rgba(0,0,0,0.25) !important;
    transition: transform 0.2s ease, box-shadow 0.2s ease;
    height: 130px;
}

.dashboard-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 12px 28px rgba(0,0,0,0.35);
}

.dashboard-label {
    color: #c9d4e9 !important;
    font-size: 15px !important;
    margin-bottom: 6px;
}

.dashboard-number {
    font-size: 42px !important;
    font-weight: 700 !important;
    color: #4fc3f7 !important;
}

/* ===============================
   TABLAS
================================ */
.table td, .table th {
    color: #e6e9f5 !important;
    background: #1a253b !important;
}

.table thead th {
    background: #24345a !important;
    color: #ffffff !important;
}

.table-hover tbody tr:hover td {
    background: #2a3c63 !important;
}





  </style>
</head>
<body>
<div class="container-fluid">
  <div class="row">
    <nav class="col-12 col-md-3 col-lg-2 sidebar p-3">
      <h5 class="mb-3"><?php echo h(APP_NAME); ?></h5>
      <div class="small text-muted mb-3">
        Usuario: <?php echo h($user['nombre']); ?><br>
        Rol: <?php echo isSuperadmin() ? 'Superadmin' : 'Admin empresa'; ?><br>
        Empresa: <?php echo h($empresaNombre); ?>
      </div>
      <hr>
      <div class="mb-2 text-uppercase small text-muted">Menú</div>
      <a href="dashboard.php">Dashboard</a>
      <?php if (isSuperadmin()): ?>
        <a href="empresas.php">Empresas</a>
        <a href="users.php">Usuarios</a>
        <a href="vacantes_all.php">Vacantes</a>
      <?php else: ?>
        <a href="vacantes.php">Vacantes</a>
        <a href="cvs.php">CVs</a>
      <?php endif; ?>
      <a href="logout.php">Salir</a>
    </nav>
    <main class="col-12 col-md-9 col-lg-10 p-4">
