<?php
require_once __DIR__ . '/header.php';
requireSuperadmin();

$empresas = $pdo->query("SELECT * FROM empresas ORDER BY created_at DESC")->fetchAll();
?>
<h1 class="h4 mb-3">Empresas</h1>
<a href="empresa_form.php" class="btn btn-sm btn-primary mb-3">Nueva empresa</a>
<table class="table table-dark table-sm align-middle">
  <thead>
    <tr>
      <th>ID</th>
      <th>Nombre</th>
      <th>Color</th>
      <th>Activa</th>
      <th>Creada</th>
      <th></th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($empresas as $e): ?>
    <tr>
      <td><?php echo (int)$e['id']; ?></td>
      <td><?php echo h($e['nombre']); ?></td>
      <td>
        <?php if ($e['color_primario']): ?>
          <span class="badge" style="background:<?php echo h($e['color_primario']); ?>">Color</span>
        <?php endif; ?>
      </td>
      <td><?php echo $e['is_active'] ? 'Sí' : 'No'; ?></td>
      <td><?php echo formatDate($e['created_at']); ?></td>
      <td class="text-end">
        <a href="empresa_form.php?id=<?php echo (int)$e['id']; ?>" class="btn btn-sm btn-outline-light">Editar</a>
      </td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php require_once __DIR__ . '/footer.php'; ?>
