<?php
require_once __DIR__ . '/header.php';
requireSuperadmin();

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

$empresa = [
  'nombre' => '',
  'slug' => '',
  'logo' => '',
  'color_primario' => '',
  'is_active' => 1,
];

/* ======================================================
   MODO EDICIÓN
====================================================== */
if ($id) {
    $stmt = $pdo->prepare("SELECT * FROM empresas WHERE id = ?");
    $stmt->execute([$id]);
    $empresa = $stmt->fetch(PDO::FETCH_ASSOC) ?: $empresa;
}

$errorMsg = '';

/* ======================================================
   PROCESAR FORMULARIO
====================================================== */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $nombre = trim($_POST['nombre'] ?? '');
    $slug = trim($_POST['slug'] ?? '');
    $color = trim($_POST['color_primario'] ?? '');
    $is_active = !empty($_POST['is_active']) ? 1 : 0;

    // Imagen final (si no sube nueva, se conserva la anterior)
    $logoFinal = $empresa['logo'];

    // SUBIR LOGO NUEVO
    if (!empty($_FILES['logo']['name'])) {

        $allowed = ['jpg','jpeg','png','webp'];
        $ext = strtolower(pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION));

        if (in_array($ext, $allowed)) {

            $uploadDir = __DIR__ . "/uploads/empresas";
            if (!is_dir($uploadDir)) mkdir($uploadDir, 0775, true);

            $fileName = time() . "_" . preg_replace("/[^a-zA-Z0-9_\.-]/", "", $_FILES['logo']['name']);
            $destino = $uploadDir . "/" . $fileName;

            if (move_uploaded_file($_FILES['logo']['tmp_name'], $destino)) {
                $logoFinal = "uploads/empresas/" . $fileName;
            }
        } else {
            $errorMsg = "Formato de logo no permitido. Solo JPG, PNG, WEBP.";
        }
    }

    if ($nombre && !$errorMsg) {

        if ($id) {
            // UPDATE
            $stmt = $pdo->prepare("
                UPDATE empresas 
                SET nombre=?, slug=?, logo=?, color_primario=?, is_active=?
                WHERE id=?
            ");
            $stmt->execute([$nombre, $slug, $logoFinal, $color, $is_active, $id]);

        } else {
            // INSERT
            $stmt = $pdo->prepare("
                INSERT INTO empresas (nombre, slug, logo, color_primario, is_active)
                VALUES (?,?,?,?,?)
            ");
            $stmt->execute([$nombre, $slug, $logoFinal, $color, $is_active]);
        }

        redirect('admin/empresas.php');
    }
}
?>

<h1 class="h4 mb-3"><?php echo $id ? 'Editar empresa' : 'Nueva empresa'; ?></h1>

<?php if ($errorMsg): ?>
  <div class="alert alert-danger"><?php echo h($errorMsg); ?></div>
<?php endif; ?>

<form method="post" enctype="multipart/form-data" class="card card-body bg-dark border-secondary">

  <div class="mb-3">
    <label class="form-label">Nombre</label>
    <input type="text" name="nombre" class="form-control" required 
           value="<?= h($empresa['nombre']); ?>">
  </div>

  <div class="mb-3">
    <label class="form-label">Slug (opcional)</label>
    <input type="text" name="slug" class="form-control" 
           value="<?= h($empresa['slug']); ?>">
  </div>

  <!-- SUBIR LOGO -->
  <div class="mb-3">
    <label class="form-label">Logo (archivo)</label>
    <input type="file" name="logo" class="form-control" accept="image/*">

    <?php if ($empresa['logo']): ?>
      <div class="mt-2">
        <small class="text-muted">Logo actual:</small><br>
        <img src="/<?= h($empresa['logo']); ?>" 
             style="max-height: 80px; border-radius: 6px;">
      </div>
    <?php endif; ?>
  </div>

  <div class="mb-3">
    <label class="form-label">Color primario (hex)</label>
    <input type="text" name="color_primario" class="form-control" 
           placeholder="#0d6efd" 
           value="<?= h($empresa['color_primario']); ?>">
  </div>

  <div class="form-check mb-3">
    <input class="form-check-input" type="checkbox" name="is_active" value="1" id="empActive"
           <?= $empresa['is_active'] ? 'checked' : ''; ?>>
    <label class="form-check-label" for="empActive">
      Empresa activa
    </label>
  </div>

  <button class="btn btn-primary" type="submit">Guardar</button>
  <a href="empresas.php" class="btn btn-secondary">Cancelar</a>

</form>

<?php require_once __DIR__ . '/footer.php'; ?>
