<?php
require_once __DIR__ . '/header.php';

// Estadísticas para superadmin o admin normal
if (isSuperadmin()) {
    $totEmp   = $pdo->query("SELECT COUNT(*) AS c FROM empresas")->fetch()['c'] ?? 0;
    $totUsers = $pdo->query("SELECT COUNT(*) AS c FROM users")->fetch()['c'] ?? 0;
    $totVac   = $pdo->query("SELECT COUNT(*) AS c FROM vacantes")->fetch()['c'] ?? 0;
    $totCV    = $pdo->query("SELECT COUNT(*) AS c FROM cvs")->fetch()['c'] ?? 0;

} else {
    $eid = currentEmpresaId();

    $totEmp = 1;

    $stmt = $pdo->prepare("SELECT COUNT(*) AS c FROM users WHERE empresa_id = ?");
    $stmt->execute([$eid]);
    $totUsers = $stmt->fetch()['c'] ?? 0;

    $stmt = $pdo->prepare("SELECT COUNT(*) AS c FROM vacantes WHERE empresa_id = ?");
    $stmt->execute([$eid]);
    $totVac = $stmt->fetch()['c'] ?? 0;

    $stmt = $pdo->prepare("
        SELECT COUNT(DISTINCT p.cv_id) AS c
        FROM postulaciones p
        JOIN vacantes v ON v.id = p.vacante_id
        WHERE v.empresa_id = ?
    ");
    $stmt->execute([$eid]);
    $totCV = $stmt->fetch()['c'] ?? 0;
}
?>

<!----------------------- DASHBOARD ------------------------>

<h1 class="h3 mb-4">Dashboard</h1>

<!-- TARJETAS KPI -->
<div class="row g-3">

  <div class="col-6 col-md-3">
    <div class="dashboard-card">
      <div class="dashboard-label">Empresas</div>
      <div class="dashboard-number"><?= (int)$totEmp ?></div>
    </div>
  </div>

  <div class="col-6 col-md-3">
    <div class="dashboard-card">
      <div class="dashboard-label">Usuarios</div>
      <div class="dashboard-number"><?= (int)$totUsers ?></div>
    </div>
  </div>

  <div class="col-6 col-md-3">
    <div class="dashboard-card">
      <div class="dashboard-label">Vacantes</div>
      <div class="dashboard-number"><?= (int)$totVac ?></div>
    </div>
  </div>

  <div class="col-6 col-md-3">
    <div class="dashboard-card">
      <div class="dashboard-label">CVs</div>
      <div class="dashboard-number"><?= (int)$totCV ?></div>
    </div>
  </div>

</div>

<?php require_once __DIR__ . '/footer.php'; ?>
