<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (!defined('APP_NAME')) {
    define('APP_NAME', 'SaaS RH Multiempresa');
}

function h($str) {
    return htmlspecialchars($str ?? '', ENT_QUOTES, 'UTF-8');
}

function isInstalled() {
    return defined('DB_HOST');
}

function redirect($path) {
    // Si recibimos URL absoluta, redirigimos tal cual
    if (preg_match('~^https?://~i', $path)) {
        header('Location: ' . $path);
        exit;
    }
    $base = defined('BASE_URL') ? rtrim(BASE_URL, '/') : '';
    header('Location: ' . $base . '/' . ltrim($path, '/'));
    exit;
}

function currentUser() {
    if (empty($_SESSION['user'])) return null;
    return $_SESSION['user'];
}

function currentUserId() {
    $u = currentUser();
    return $u['id'] ?? null;
}

function currentEmpresaId() {
    $u = currentUser();
    return $u['empresa_id'] ?? null;
}

function currentRole() {
    $u = currentUser();
    return $u['role'] ?? null;
}

function isSuperadmin() {
    return currentRole() == 1;
}

function requireLogin() {
    if (!currentUserId()) {
        redirect('admin/login.php');
    }
}

function requireSuperadmin() {
    requireLogin();
    if (!isSuperadmin()) {
        redirect('admin/dashboard.php');
    }
}

// Formato simple de fecha
function formatDate($ts) {
    if (!$ts) return '';
    return date('d/m/Y H:i', strtotime($ts));
}
