<?php
require_once __DIR__ . '/header.php';

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// Valores por defecto
$vacante = [
  'empresa_id' => currentEmpresaId(),
  'titulo'     => '',
  'descripcion'=> '',
  'ubicacion'  => '',
  'modalidad'  => '',
  'tipo'       => '',
  'salario'    => '',
  'estado'     => 'abierta',
  'imagen'     => ''
];

$errorMsg = '';

// Si estamos editando, cargamos la vacante
if ($id) {
    $stmt = $pdo->prepare("SELECT * FROM vacantes WHERE id = ?");
    $stmt->execute([$id]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($row) {
        $vacante = $row;
    } else {
        echo '<div class="alert alert-danger">La vacante no existe.</div>';
        require_once __DIR__ . '/footer.php';
        exit;
    }
}

// Cargar empresas (solo superadmin las usa en un select)
$empresas = [];
if (isSuperadmin()) {
    $empresas = $pdo->query("SELECT id, nombre FROM empresas ORDER BY nombre ASC")->fetchAll(PDO::FETCH_ASSOC);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Empresa: superadmin la elige, admin normal usa su empresa
    if (isSuperadmin()) {
        $empresa_id = isset($_POST['empresa_id']) ? (int)$_POST['empresa_id'] : 0;
    } else {
        $empresa_id = currentEmpresaId();
    }

    $titulo      = trim($_POST['titulo'] ?? '');
    $descripcion = trim($_POST['descripcion'] ?? '');
    $ubicacion   = trim($_POST['ubicacion'] ?? '');
    $modalidad   = trim($_POST['modalidad'] ?? '');
    $tipo        = trim($_POST['tipo'] ?? '');
    $salario     = trim($_POST['salario'] ?? '');
    $estado      = trim($_POST['estado'] ?? 'abierta');
    $imagen      = trim($_POST['imagen'] ?? '');

    // Actualizamos arreglo para que el form "recuerde" lo capturado ante error
    $vacante = [
      'empresa_id' => $empresa_id,
      'titulo'     => $titulo,
      'descripcion'=> $descripcion,
      'ubicacion'  => $ubicacion,
      'modalidad'  => $modalidad,
      'tipo'       => $tipo,
      'salario'    => $salario,
      'estado'     => $estado,
      'imagen'     => $imagen
    ];

    if (!$empresa_id || !$titulo) {
        $errorMsg = 'Debes capturar al menos la empresa y el ttulo de la vacante.';
    } else {
        if ($id) {
            // UPDATE
            $stmt = $pdo->prepare("UPDATE vacantes
                SET empresa_id = ?, titulo = ?, descripcion = ?, ubicacion = ?,
                    modalidad = ?, tipo = ?, salario = ?, estado = ?, imagen = ?
                WHERE id = ?");
            $stmt->execute([
                $empresa_id, $titulo, $descripcion, $ubicacion,
                $modalidad, $tipo, $salario, $estado, $imagen, $id
            ]);
        } else {
            // INSERT
            $stmt = $pdo->prepare("INSERT INTO vacantes
                (empresa_id, titulo, descripcion, ubicacion, modalidad, tipo, salario, estado, imagen)
                VALUES (?,?,?,?,?,?,?,?,?)");
            $stmt->execute([
                $empresa_id, $titulo, $descripcion, $ubicacion,
                $modalidad, $tipo, $salario, $estado, $imagen
            ]);
        }
        redirect('admin/vacantes.php');
    }
}
?>
<h1 class="h4 mb-3"><?php echo $id ? 'Editar vacante' : 'Nueva vacante'; ?></h1>

<?php if ($errorMsg): ?>
  <div class="alert alert-danger"><?php echo h($errorMsg); ?></div>
<?php endif; ?>

<form method="post" class="card card-body bg-dark border-secondary">
  <?php if (isSuperadmin()): ?>
    <div class="mb-3">
      <label class="form-label">Empresa</label>
      <select name="empresa_id" class="form-select" required>
        <option value="">-- Selecciona empresa --</option>
        <?php foreach ($empresas as $e): ?>
          <option value="<?php echo (int)$e['id']; ?>"
            <?php echo ($vacante['empresa_id'] == $e['id']) ? 'selected' : ''; ?>>
            <?php echo h($e['nombre']); ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>
  <?php else: ?>
    <div class="mb-3">
      <label class="form-label">Empresa</label>
      <input type="text" class="form-control" value="<?php echo h($empresaNombre ?? 'Tu empresa'); ?>" disabled>
      <input type="hidden" name="empresa_id" value="<?php echo (int)$vacante['empresa_id']; ?>">
    </div>
  <?php endif; ?>

  <div class="mb-3">
    <label class="form-label">Ttulo de la vacante</label>
    <input type="text" name="titulo" class="form-control" required
           value="<?php echo h($vacante['titulo']); ?>">
  </div>

  <div class="mb-3">
    <label class="form-label">Descripcin</label>
    <textarea name="descripcion" class="form-control" rows="5"><?php echo h($vacante['descripcion']); ?></textarea>
  </div>

  <div class="row">
    <div class="col-md-4 mb-3">
      <label class="form-label">Ubicacin</label>
      <input type="text" name="ubicacion" class="form-control"
             value="<?php echo h($vacante['ubicacion']); ?>">
    </div>
    <div class="col-md-4 mb-3">
      <label class="form-label">Modalidad</label>
      <input type="text" name="modalidad" class="form-control" placeholder="Presencial, remoto, hbrido"
             value="<?php echo h($vacante['modalidad']); ?>">
    </div>
    <div class="col-md-4 mb-3">
      <label class="form-label">Tipo de puesto</label>
      <input type="text" name="tipo" class="form-control" placeholder="Tiempo completo, medio tiempo, etc."
             value="<?php echo h($vacante['tipo']); ?>">
    </div>
  </div>

  <div class="mb-3">
    <label class="form-label">Rango salarial (texto libre)</label>
    <input type="text" name="salario" class="form-control" placeholder="$20,000 - $30,000 MXN"
           value="<?php echo h($vacante['salario']); ?>">
  </div>

  <div class="mb-3">
    <label class="form-label">URL de imagen (opcional)</label>
    <input type="text" name="imagen" class="form-control"
           placeholder="https://ejemplo.com/imagen-puesto.jpg"
           value="<?php echo h($vacante['imagen']); ?>">
    <div class="form-text text-muted">Se mostrar en el front si proporcionas una imagen.</div>
  </div>

  <div class="mb-3">
    <label class="form-label">Estado</label>
    <select name="estado" class="form-select">
      <option value="abierta" <?php echo $vacante['estado']=='abierta'?'selected':''; ?>>Abierta</option>
      <option value="cerrada" <?php echo $vacante['estado']=='cerrada'?'selected':''; ?>>Cerrada</option>
    </select>
  </div>

  <button type="submit" class="btn btn-primary">Guardar</button>
  <a href="vacantes.php" class="btn btn-secondary">Cancelar</a>
</form>

<?php require_once __DIR__ . '/footer.php'; ?>
