<?php
require_once __DIR__ . '/header.php';
requireSuperadmin();

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$userData = [
  'empresa_id' => null,
  'nombre' => '',
  'email' => '',
  'role' => 2,
  'is_active' => 1,
];

if ($id) {
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$id]);
    $userData = $stmt->fetch() ?: $userData;
}

$empresas = $pdo->query("SELECT id, nombre FROM empresas WHERE is_active = 1 ORDER BY nombre")->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $empresa_id = strlen($_POST['empresa_id'] ?? '') ? (int)$_POST['empresa_id'] : null;
    $nombre = trim($_POST['nombre'] ?? '');
    $email  = trim($_POST['email'] ?? '');
    $role   = (int)($_POST['role'] ?? 2);
    $is_active = !empty($_POST['is_active']) ? 1 : 0;
    $password = $_POST['password'] ?? '';

    if ($nombre && $email) {
        if ($id) {
            // update
            if ($password) {
                $hash = password_hash($password, PASSWORD_BCRYPT);
                $stmt = $pdo->prepare("UPDATE users SET empresa_id=?, nombre=?, email=?, role=?, is_active=?, password_hash=? WHERE id=?");
                $stmt->execute([$empresa_id, $nombre, $email, $role, $is_active, $hash, $id]);
            } else {
                $stmt = $pdo->prepare("UPDATE users SET empresa_id=?, nombre=?, email=?, role=?, is_active=? WHERE id=?");
                $stmt->execute([$empresa_id, $nombre, $email, $role, $is_active, $id]);
            }
        } else {
            if (!$password) {
                $password = '123456';
            }
            $hash = password_hash($password, PASSWORD_BCRYPT);
            $stmt = $pdo->prepare("INSERT INTO users (empresa_id, nombre, email, password_hash, role, is_active)
                                   VALUES (?,?,?,?,?,?)");
            $stmt->execute([$empresa_id, $nombre, $email, $hash, $role, $is_active]);
        }
        redirect('admin/users.php');
    }
}
?>
<h1 class="h4 mb-3"><?php echo $id ? 'Editar usuario' : 'Nuevo usuario'; ?></h1>
<form method="post">
  <div class="mb-3">
    <label class="form-label">Empresa (solo admin empresa)</label>
    <select name="empresa_id" class="form-select">
      <option value="">-- Sin empresa (superadmin global) --</option>
      <?php foreach ($empresas as $e): ?>
        <option value="<?php echo (int)$e['id']; ?>" <?php echo ($userData['empresa_id'] == $e['id']) ? 'selected' : ''; ?>>
          <?php echo h($e['nombre']); ?>
        </option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="mb-3">
    <label class="form-label">Nombre</label>
    <input type="text" name="nombre" class="form-control" required value="<?php echo h($userData['nombre']); ?>">
  </div>
  <div class="mb-3">
    <label class="form-label">Correo</label>
    <input type="email" name="email" class="form-control" required value="<?php echo h($userData['email']); ?>">
  </div>
  <div class="mb-3">
    <label class="form-label">Rol</label>
    <select name="role" class="form-select">
      <option value="1" <?php echo $userData['role']==1?'selected':''; ?>>Superadmin</option>
      <option value="2" <?php echo $userData['role']==2?'selected':''; ?>>Admin empresa</option>
    </select>
  </div>
  <div class="mb-3">
    <label class="form-label">Contraseña <?php echo $id ? '(dejar en blanco para no cambiar)' : ''; ?></label>
    <input type="password" name="password" class="form-control">
  </div>
  <div class="form-check mb-3">
    <input class="form-check-input" type="checkbox" name="is_active" value="1" id="uActive"
           <?php echo $userData['is_active'] ? 'checked' : ''; ?>>
    <label class="form-check-label" for="uActive">
      Usuario activo
    </label>
  </div>
  <button class="btn btn-primary" type="submit">Guardar</button>
  <a href="users.php" class="btn btn-secondary">Cancelar</a>
</form>
<?php require_once __DIR__ . '/footer.php'; ?>
