<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../functions.php';
require_once __DIR__ . '/../db.php';

requireLogin();

$user = currentUser();
$empresaNombre = 'Sin empresa';
$empresaColor = '#0d6efd';

if ($user['empresa_id']) {
    $stmtEmp = $pdo->prepare("SELECT nombre, color_primario FROM empresas WHERE id = ?");
    $stmtEmp->execute([$user['empresa_id']]);
    if ($row = $stmtEmp->fetch()) {
        $empresaNombre = $row['nombre'];
        if (!empty($row['color_primario'])) {
            $empresaColor = $row['color_primario'];
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <title><?php echo APP_NAME; ?> | Admin</title>
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background:#0b1021; color:#f8f9fa; }
    .sidebar {
      min-height:100vh;
      background:#111827;
    }
    .sidebar a {
      color:#cbd5f5;
      text-decoration:none;
      display:block;
      padding:10px 12px;
      border-radius:6px;
      margin-bottom:4px;
    }
    .sidebar a.active,
    .sidebar a:hover {
      background:#1f2937;
    }
  </style>
</head>
<body>
<div class="container-fluid">
  <div class="row">
    <nav class="col-12 col-md-3 col-lg-2 sidebar p-3">
      <h5 class="mb-3"><?php echo h(APP_NAME); ?></h5>
      <div class="small text-muted mb-3">
        Usuario: <?php echo h($user['nombre']); ?><br>
        Rol: <?php echo isSuperadmin() ? 'Superadmin' : 'Admin empresa'; ?><br>
        Empresa: <?php echo h($empresaNombre); ?>
      </div>
      <hr>
      <div class="mb-2 text-uppercase small text-muted">Menú</div>
      <a href="dashboard.php">Dashboard</a>
      <?php if (isSuperadmin()): ?>
        <a href="empresas.php">Empresas</a>
        <a href="users.php">Usuarios</a>
      <?php else: ?>
        <a href="vacantes.php">Vacantes</a>
        <a href="cvs.php">CVs</a>
      <?php endif; ?>
      <a href="logout.php">Salir</a>
    </nav>
    <main class="col-12 col-md-9 col-lg-10 p-4">
