<?php
require_once __DIR__ . '/header.php';
requireSuperadmin();

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$empresa = [
  'nombre' => '',
  'slug' => '',
  'logo' => '',
  'color_primario' => '',
  'is_active' => 1,
];

if ($id) {
    $stmt = $pdo->prepare("SELECT * FROM empresas WHERE id = ?");
    $stmt->execute([$id]);
    $empresa = $stmt->fetch() ?: $empresa;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nombre = trim($_POST['nombre'] ?? '');
    $slug = trim($_POST['slug'] ?? '');
    $logo = trim($_POST['logo'] ?? '');
    $color = trim($_POST['color_primario'] ?? '');
    $is_active = !empty($_POST['is_active']) ? 1 : 0;

    if ($nombre) {
        if ($id) {
            $stmt = $pdo->prepare("UPDATE empresas SET nombre=?, slug=?, logo=?, color_primario=?, is_active=? WHERE id=?");
            $stmt->execute([$nombre, $slug, $logo, $color, $is_active, $id]);
        } else {
            $stmt = $pdo->prepare("INSERT INTO empresas (nombre, slug, logo, color_primario, is_active)
                                   VALUES (?,?,?,?,?)");
            $stmt->execute([$nombre, $slug, $logo, $color, $is_active]);
        }
        redirect('admin/empresas.php');
    }
}
?>
<h1 class="h4 mb-3"><?php echo $id ? 'Editar empresa' : 'Nueva empresa'; ?></h1>
<form method="post">
  <div class="mb-3">
    <label class="form-label">Nombre</label>
    <input type="text" name="nombre" class="form-control" required value="<?php echo h($empresa['nombre']); ?>">
  </div>
  <div class="mb-3">
    <label class="form-label">Slug (opcional)</label>
    <input type="text" name="slug" class="form-control" value="<?php echo h($empresa['slug']); ?>">
  </div>
  <div class="mb-3">
    <label class="form-label">Logo (URL opcional)</label>
    <input type="text" name="logo" class="form-control" value="<?php echo h($empresa['logo']); ?>">
  </div>
  <div class="mb-3">
    <label class="form-label">Color primario (hex)</label>
    <input type="text" name="color_primario" class="form-control" placeholder="#0d6efd" value="<?php echo h($empresa['color_primario']); ?>">
  </div>
  <div class="form-check mb-3">
    <input class="form-check-input" type="checkbox" name="is_active" value="1" id="empActive"
           <?php echo $empresa['is_active'] ? 'checked' : ''; ?>>
    <label class="form-check-label" for="empActive">
      Empresa activa
    </label>
  </div>
  <button class="btn btn-primary" type="submit">Guardar</button>
  <a href="empresas.php" class="btn btn-secondary">Cancelar</a>
</form>
<?php require_once __DIR__ . '/footer.php'; ?>
