<?php
require_once __DIR__ . '/header.php';

// Estadísticas básicas
if (isSuperadmin()) {
    // Global
    $totEmp = $pdo->query("SELECT COUNT(*) AS c FROM empresas")->fetch()['c'] ?? 0;
    $totUsers = $pdo->query("SELECT COUNT(*) AS c FROM users")->fetch()['c'] ?? 0;
    $totVac = $pdo->query("SELECT COUNT(*) AS c FROM vacantes")->fetch()['c'] ?? 0;
    $totCV = $pdo->query("SELECT COUNT(*) AS c FROM cvs")->fetch()['c'] ?? 0;
} else {
    $eid = currentEmpresaId();
    $totEmp = 1;
    $stmt = $pdo->prepare("SELECT COUNT(*) AS c FROM users WHERE empresa_id = ?");
    $stmt->execute([$eid]);
    $totUsers = $stmt->fetch()['c'] ?? 0;

    $stmt = $pdo->prepare("SELECT COUNT(*) AS c FROM vacantes WHERE empresa_id = ?");
    $stmt->execute([$eid]);
    $totVac = $stmt->fetch()['c'] ?? 0;

    $stmt = $pdo->prepare("SELECT COUNT(DISTINCT p.cv_id) AS c
                           FROM postulaciones p
                           JOIN vacantes v ON v.id = p.vacante_id
                           WHERE v.empresa_id = ?");
    $stmt->execute([$eid]);
    $totCV = $stmt->fetch()['c'] ?? 0;
}
?>
<h1 class="h3 mb-4">Dashboard</h1>

<div class="row g-3">
  <div class="col-6 col-md-3">
    <div class="card bg-dark border-0">
      <div class="card-body">
        <div class="text-muted small">Empresas</div>
        <div class="h4 mb-0"><?php echo (int)$totEmp; ?></div>
      </div>
    </div>
  </div>
  <div class="col-6 col-md-3">
    <div class="card bg-dark border-0">
      <div class="card-body">
        <div class="text-muted small">Usuarios</div>
        <div class="h4 mb-0"><?php echo (int)$totUsers; ?></div>
      </div>
    </div>
  </div>
  <div class="col-6 col-md-3">
    <div class="card bg-dark border-0">
      <div class="card-body">
        <div class="text-muted small">Vacantes</div>
        <div class="h4 mb-0"><?php echo (int)$totVac; ?></div>
      </div>
    </div>
  </div>
  <div class="col-6 col-md-3">
    <div class="card bg-dark border-0">
      <div class="card-body">
        <div class="text-muted small">CVs</div>
        <div class="h4 mb-0"><?php echo (int)$totCV; ?></div>
      </div>
    </div>
  </div>
</div>

<?php require_once __DIR__ . '/footer.php'; ?>
