<?php
require_once __DIR__ . '/header.php';

if (isSuperadmin()) {
    $sql = "SELECT c.*, GROUP_CONCAT(DISTINCT v.titulo SEPARATOR ', ') AS vacantes
            FROM cvs c
            LEFT JOIN postulaciones p ON p.cv_id = c.id
            LEFT JOIN vacantes v ON v.id = p.vacante_id
            GROUP BY c.id
            ORDER BY c.created_at DESC";
    $rows = $pdo->query($sql)->fetchAll();
} else {
    $eid = currentEmpresaId();
    $stmt = $pdo->prepare("SELECT c.*, GROUP_CONCAT(DISTINCT v.titulo SEPARATOR ', ') AS vacantes
            FROM cvs c
            LEFT JOIN postulaciones p ON p.cv_id = c.id
            LEFT JOIN vacantes v ON v.id = p.vacante_id
            WHERE v.empresa_id = ?
            GROUP BY c.id
            ORDER BY c.created_at DESC");
    $stmt->execute([$eid]);
    $rows = $stmt->fetchAll();
}
?>
<h1 class="h4 mb-3">CVs recibidos</h1>
<table class="table table-dark table-sm align-middle">
  <thead>
    <tr>
      <th>ID</th>
      <th>Nombre</th>
      <th>Email</th>
      <th>Teléfono</th>
      <th>Vacantes</th>
      <th>Fecha</th>
      <th></th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($rows as $c): ?>
    <tr>
      <td><?php echo (int)$c['id']; ?></td>
      <td><?php echo h($c['nombre']); ?></td>
      <td><?php echo h($c['email']); ?></td>
      <td><?php echo h($c['telefono']); ?></td>
      <td><?php echo h($c['vacantes']); ?></td>
      <td><?php echo formatDate($c['created_at']); ?></td>
      <td class="text-end">
        <?php if ($c['archivo']): ?>
          <a href="<?php echo h($c['archivo']); ?>" target="_blank" class="btn btn-sm btn-outline-light">Ver CV</a>
        <?php endif; ?>
      </td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php require_once __DIR__ . '/footer.php'; ?>
