<?php
$data = json_decode(file_get_contents('php://input'), true);

if (!isset($data['image']) || !isset($data['name'])) {
  http_response_code(400);
  echo json_encode(['error' => 'Datos incompletos']);
  exit;
}

$imageData = $data['image'];
$name = basename($data['name']); // seguridad

$base64 = explode(',', $imageData)[1];
$decoded = base64_decode($base64);

// Asegúrate de que la carpeta giftcards exista
$folder = __DIR__ . '/giftcards/';
if (!is_dir($folder)) {
  mkdir($folder, 0777, true);
}

file_put_contents($folder . $name, $decoded);

echo json_encode(['success' => true, 'filename' => $name]);