<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require __DIR__ . "/db.php"; // Carga la conexión PDO en $pdo

header('Content-Type: application/json');

// Verifica conexión
if (!isset($pdo)) {
    echo json_encode([
        "success" => false,
        "error" => "No se pudo cargar PDO (pdo no existe)."
    ]);
    exit;
}

try {
    $stmt = $pdo->prepare("SELECT id, amount, title, description, icon 
                           FROM amount_options
                           WHERE is_active = 1
                           ORDER BY amount ASC");
    $stmt->execute();
    $options = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        "success" => true,
        "options" => $options
    ]);

} catch (Exception $e) {
    echo json_encode([
        "success" => false,
        "error" => $e->getMessage()
    ]);
}
