<?php
require_once __DIR__ . '/header.php';
global $pdo;

$settings = getSettings();
$msg = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

  $business = $_POST['business_name'] ?? '';
  $baseUrl  = $_POST['base_url'] ?? '';
  $stripePub= $_POST['stripe_public_key'] ?? '';
  $stripeSec= $_POST['stripe_secret_key'] ?? '';
  $smtpHost = $_POST['smtp_host'] ?? '';
  $smtpPort = (int)($_POST['smtp_port'] ?? 587);
  $smtpUser = $_POST['smtp_user'] ?? '';
  $smtpPass = $_POST['smtp_pass'] ?? '';
  $smtpFrom = $_POST['smtp_from_email'] ?? '';
  $smtpFromNm= $_POST['smtp_from_name'] ?? '';
  $ppc      = (float)($_POST['points_per_currency'] ?? 1.0);
  $curr     = $_POST['currency_unit'] ?? 'MXN';
  $daysVal  = (int)($_POST['default_days_valid'] ?? 30);

  /* ===========================================
     SUBIDA DE LOGO
  ============================================ */
  $newLogoName = $settings['logo_filename'] ?? 'logo.png';

  if (!empty($_FILES['logo_file']['name'])) {
      $file = $_FILES['logo_file'];
      $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));

      if (in_array($ext, ['png','jpg','jpeg'])) {

          $newLogoName = "logo." . $ext;
          $uploadPath = __DIR__ . '/../logo/' . $newLogoName;

          if (move_uploaded_file($file['tmp_name'], $uploadPath)) {
              // Actualizado OK
          }
      }
  }

  // ===============================
  // Guardar en BD
  // ===============================
  $stmt = $pdo->query("SELECT id FROM settings LIMIT 1");
  $row  = $stmt->fetch();

  if ($row) {
    $id = $row['id'];

    $upd = $pdo->prepare("UPDATE settings SET 
      business_name=?, base_url=?, stripe_public_key=?, stripe_secret_key=?,
      smtp_host=?, smtp_port=?, smtp_user=?, smtp_pass=?, smtp_from_email=?, smtp_from_name=?,
      points_per_currency=?, currency_unit=?, default_days_valid=?, logo_filename=?
      WHERE id=?");
      
    $upd->execute([
      $business,$baseUrl,$stripePub,$stripeSec,
      $smtpHost,$smtpPort,$smtpUser,$smtpPass,$smtpFrom,$smtpFromNm,
      $ppc,$curr,$daysVal,$newLogoName,$id
    ]);

  } else {

    $ins = $pdo->prepare("INSERT INTO settings
      (business_name, base_url, stripe_public_key, stripe_secret_key,
       smtp_host, smtp_port, smtp_user, smtp_pass, smtp_from_email, smtp_from_name,
       points_per_currency, currency_unit, default_days_valid, logo_filename)
       VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)");

    $ins->execute([
      $business,$baseUrl,$stripePub,$stripeSec,
      $smtpHost,$smtpPort,$smtpUser,$smtpPass,$smtpFrom,$smtpFromNm,
      $ppc,$curr,$daysVal,$newLogoName
    ]);
  }

  $settings = getSettings();
  $msg = "Configuración actualizada.";
}
?>
<h1 class="h4 mb-3">Configuración</h1>

<?php if ($msg): ?>
  <div class="alert alert-success"><?php echo htmlspecialchars($msg); ?></div>
<?php endif; ?>

<form method="post" class="card card-body mb-4" enctype="multipart/form-data">

  <h2 class="h6">Negocio</h2>
  <div class="mb-3">
    <label class="form-label">Nombre del negocio</label>
    <input type="text" name="business_name" class="form-control" 
           value="<?php echo htmlspecialchars($settings['business_name'] ?? ''); ?>">
  </div>

  <div class="mb-3">
    <label class="form-label">Base URL</label>
    <input type="text" name="base_url" class="form-control" 
           value="<?php echo htmlspecialchars($settings['base_url'] ?? ''); ?>">
  </div>

  <!-- ================================
       LOGO DEL SISTEMA
  ================================= -->
  <h2 class="h6 mt-4"></h2>

  <?php 
    $logoFile = $settings['logo_filename'] ?? 'logo.png';
    $logoPath = BASE_URL . 'logo/' . $logoFile; 
  ?>

  <div class="mb-3">
    <label class="form-label fw-semibold">Logo actual</label><br>
    
    
    <?php 
$logoFile = $settings['logo_filename'] ?? 'logo.png';
$logoPath = BASE_URL . 'logo/' . $logoFile . '?v=' . time(); 
?>
    
    
    <img src="<?php echo $logoPath; ?>" 
         style="max-width:160px; border-radius:12px; margin-bottom:10px;">
  </div>

  <div class="mb-3">
    <label class="form-label">Subir nuevo logo</label>
    <input type="file" name="logo_file" class="form-control">
    <div class="form-text">Formatos permitidos: PNG, JPG. Reemplaza el actual.</div>
  </div>

  <h2 class="h6 mt-3">Stripe</h2>
  <div class="row mb-3">
    <div class="col-md-6">
      <label class="form-label">Public Key</label>
      <input type="text" name="stripe_public_key" class="form-control" 
             value="<?php echo htmlspecialchars($settings['stripe_public_key'] ?? ''); ?>">
    </div>
    <div class="col-md-6">
      <label class="form-label">Secret Key</label>
      <input type="text" name="stripe_secret_key" class="form-control" 
             value="<?php echo htmlspecialchars($settings['stripe_secret_key'] ?? ''); ?>">
    </div>
  </div>

  <h2 class="h6 mt-3">Correo</h2>
  <div class="row mb-3">
    <div class="col-md-4">
      <label class="form-label">SMTP Host</label>
      <input type="text" name="smtp_host" class="form-control" value="<?php echo htmlspecialchars($settings['smtp_host'] ?? ''); ?>">
    </div>
    <div class="col-md-2">
      <label class="form-label">SMTP Port</label>
      <input type="number" name="smtp_port" class="form-control" value="<?php echo htmlspecialchars($settings['smtp_port'] ?? 587); ?>">
    </div>
    <div class="col-md-3">
      <label class="form-label">SMTP User</label>
      <input type="text" name="smtp_user" class="form-control" value="<?php echo htmlspecialchars($settings['smtp_user'] ?? ''); ?>">
    </div>
    <div class="col-md-3">
      <label class="form-label">SMTP Pass</label>
      <input type="password" name="smtp_pass" class="form-control" value="<?php echo htmlspecialchars($settings['smtp_pass'] ?? ''); ?>">
    </div>
  </div>

  <div class="row mb-3">
    <div class="col-md-6">
      <label class="form-label">From Email</label>
      <input type="email" name="smtp_from_email" class="form-control" value="<?php echo htmlspecialchars($settings['smtp_from_email'] ?? ''); ?>">
    </div>
    <div class="col-md-6">
      <label class="form-label">From Name</label>
      <input type="text" name="smtp_from_name" class="form-control" value="<?php echo htmlspecialchars($settings['smtp_from_name'] ?? ''); ?>">
    </div>
  </div>

  <h2 class="h6 mt-3">Puntos y vigencia</h2>
  <div class="row mb-3">
    <div class="col-md-4">
      <label class="form-label">Puntos por unidad de moneda</label>
      <input type="number" step="0.01" name="points_per_currency" class="form-control" value="<?php echo htmlspecialchars($settings['points_per_currency'] ?? 1.0); ?>">
    </div>
    <div class="col-md-4">
      <label class="form-label">Moneda</label>
      <input type="text" name="currency_unit" class="form-control" value="<?php echo htmlspecialchars($settings['currency_unit'] ?? 'MXN'); ?>">
    </div>
    <div class="col-md-4">
      <label class="form-label">Días de vigencia</label>
      <input type="number" name="default_days_valid" class="form-control" value="<?php echo htmlspecialchars($settings['default_days_valid'] ?? 30); ?>">
    </div>
  </div>

  <button class="btn btn-primary">Guardar configuración</button>
</form>

<?php require_once __DIR__ . '/footer.php'; ?>
