<?php
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/functions.php';

$code = trim($_GET['code'] ?? '');
$gift = null;
$msg  = null;
$valid = false;

// Cuando se envía la acción de redimir
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['redeem_code'])) {
    $redeemCode = trim($_POST['redeem_code']);

    $stmt = $pdo->prepare("SELECT * FROM giftcards WHERE code = ?");
    $stmt->execute([$redeemCode]);
    $gift = $stmt->fetch();

    if ($gift && (int)$gift['is_valid'] === 1) {
        // Marcar como usada
        $pdo->prepare("UPDATE giftcards SET is_valid = 0 WHERE code = ?")
            ->execute([$redeemCode]);

        $msg = "🎉 La tarjeta fue redimida exitosamente.";
        $valid = false; // Ya no es válida
        $code = $redeemCode;
    } else {
        $msg = "La tarjeta no se puede redimir (ya usada o inválida).";
    }
}

// Validar código ingresado por GET
if ($code !== '') {
    $stmt = $pdo->prepare("SELECT * FROM giftcards WHERE code = ?");
    $stmt->execute([$code]);
    $gift = $stmt->fetch();

    if ($gift) {
        if ((int)$gift['is_valid'] === 1) {
            $valid = true;
        } else {
            $msg = "Esta tarjeta ya fue utilizada o se encuentra inválida.";
        }
    } else {
        $msg = "No se encontró una tarjeta con ese código.";
    }
} else {
    $msg = "No se proporcionó código.";
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Validar / Redimir tarjeta</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
  <div class="row justify-content-center">
    <div class="col-md-8">
      <div class="card shadow-sm mb-3">
        <div class="card-body">
          <h1 class="h4 mb-3">Validar / Redimir tarjeta de regalo</h1>

          <form method="get" class="row g-2 mb-3">
            <div class="col-md-8">
              <input type="text" name="code" value="<?php echo htmlspecialchars($code); ?>" class="form-control" placeholder="Código de la tarjeta">
            </div>
            <div class="col-md-4">
              <button class="btn btn-primary w-100" type="submit">Buscar</button>
            </div>
          </form>

          <?php if ($msg): ?>
            <div class="alert alert-info"><?php echo htmlspecialchars($msg); ?></div>
          <?php endif; ?>

          <?php if ($gift): ?>
            <h2 class="h5 mt-3">Detalles</h2>
            <ul class="list-group mb-3">
              <li class="list-group-item"><strong>Para:</strong> <?php echo htmlspecialchars($gift['recipient_name']); ?></li>
              <li class="list-group-item"><strong>Contacto:</strong> <?php echo htmlspecialchars($gift['recipient_contact']); ?></li>
              <li class="list-group-item"><strong>Monto:</strong> $<?php echo number_format($gift['amount'],2); ?></li>
              <li class="list-group-item"><strong>Mensaje:</strong> <?php echo htmlspecialchars($gift['message']); ?></li>
              <li class="list-group-item"><strong>Vigencia (días restantes):</strong> <?php echo (int)$gift['days_remaining']; ?></li>
              <li class="list-group-item"><strong>Estado:</strong>
                <?php echo ((int)$gift['is_valid'] === 1) ? 'VÁLIDA' : 'NO VÁLIDA'; ?>
              </li>
            </ul>

            <?php if ($valid): ?>
              <form method="post" id="redeemForm">
                <input type="hidden" name="redeem_code" value="<?php echo htmlspecialchars($gift['code']); ?>">
                <button type="button" class="btn btn-success w-100" onclick="confirmRedeem()">Redimir tarjeta</button>
              </form>
            <?php endif; ?>

          <?php endif; ?>

        </div>
      </div>
      <a href="index.php" class="btn btn-secondary">Volver al inicio</a>
    </div>
  </div>
</div>

<script>
function confirmRedeem() {
  Swal.fire({
    title: "¿Redimir tarjeta?",
    text: "La tarjeta quedará marcada como utilizada.",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, redimir",
    cancelButtonText: "Cancelar"
  }).then((result) => {
    if (result.isConfirmed) {
      document.getElementById("redeemForm").submit();
    }
  });
}
</script>

</body>
</html>
