<?php
require_once __DIR__ . '/db.php';

$code = $_POST['code'] ?? '';
$code = trim($code);

header('Content-Type: application/json');

if ($code === '') {
  http_response_code(400);
  echo json_encode(['error'=>true,'message'=>'Falta código']);
  exit;
}

$stmt = $pdo->prepare("SELECT * FROM giftcards WHERE code = ?");
$stmt->execute([$code]);
$gift = $stmt->fetch();

if (!$gift) {
  http_response_code(404);
  echo json_encode(['error'=>true,'message'=>'Tarjeta no encontrada']);
  exit;
}

if ((int)$gift['is_valid'] !== 1) {
  echo json_encode(['error'=>true,'message'=>'La tarjeta ya fue utilizada o está inválida']);
  exit;
}

// Marcar como usada
$pdo->prepare("UPDATE giftcards SET is_valid = 0, days_remaining = 0 WHERE code = ?")
    ->execute([$code]);

echo json_encode(['error'=>false,'message'=>'Tarjeta redimida correctamente']);
