<?php
require_once __DIR__ . '/functions.php';
$settings = getSettings();
$business = htmlspecialchars($settings['business_name'] ?? 'Giftcards digitales');
$baseUrl  = rtrim($settings['base_url'] ?? BASE_URL, '/') . '/';
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8" />
  <title><?php echo $business; ?> - Giftcards digitales</title>

  <meta name="viewport" content="width=device-width,initial-scale=1,viewport-fit=cover" />
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="styles.css?v=1">

  <style>
    :root {
      --safe-top: env(safe-area-inset-top);
      --safe-bottom: env(safe-area-inset-bottom);
    }
  </style>

  <script>
    const BASE_URL = "<?php echo $baseUrl; ?>";
  </script>

</head>

<body class="app-body ios-fix">

<div class="app-root">

  <!-- HEADER TIPO APP IOS -->
  <header class="app-header">
    <div class="app-header-inner centered-layout">
    
      <div class="app-header-title centered">
        <!--span class="app-header-sub">Giftcards digitales</span-->
        <h1>Crear tarjetas</h1>
      </div>
    </div>

    <!-- STEPPER RENORMALIZADO 1–8 -->
    <div class="app-stepper" id="appStepper">
      <button class="app-step-dot active" data-step="1">1</button>
      <button class="app-step-dot" data-step="2">2</button>
      <button class="app-step-dot" data-step="3">3</button>
      <button class="app-step-dot" data-step="4">4</button>
      <button class="app-step-dot" data-step="5">5</button>
      <button class="app-step-dot" data-step="6">6</button>
      <button class="app-step-dot" data-step="7">7</button>
      <button class="app-step-dot" data-step="8">8</button>
    </div>
  </header>

  <!-- MAIN FLOW -->
  <main class="app-shell">


    <!-- STEP 1 -->
    <section class="step step-active" id="step1">
      <div class="step-inner">
        <div class="app-header-logo-wrap">
        
        <?php
        $settings = getSettings();
        $logo = $settings['logo_filename'] ?? 'logo.png';
        ?>
        <img src="<?php echo BASE_URL . 'logo/' . $logo; ?>" class="app-logo" alt="Logo">


      </div>
        <h2>¿Cuántas giftcards quieres crear?</h2>
        <p class="step-desc">Puedes generar varias tarjetas en una sola compra.</p>

        <input id="giftcardCount" type="number" class="form-control text-center mb-4"
               min="1" value="1">

        <div class="step-actions">
          <button class="btn-soft" disabled>Anterior</button>
          <button class="btn-main" onclick="onNextFrom1()">Siguiente</button>
        </div>
      </div>
    </section>

    <!-- STEP 2 -->
<section class="step" id="step2">
  <div class="step-inner">
    <h2>Montos por tarjeta</h2>
    <p class="step-desc">Selecciona un monto basado en su categoría.</p>

    <div id="amountContainer" class="amount-list"></div>

    <div class="step-actions">
      <button class="btn-soft" onclick="goToStep(1)">Anterior</button>
      <button class="btn-main" onclick="onNextFrom2()">Siguiente</button>
    </div>
  </div>
</section>


    <!-- STEP 3 — REMITENTE -->
    <section class="step" id="step3">
      <div class="step-inner">
        <h2>Datos del remitente</h2>
        <p class="step-desc">Estos datos aparecerán como quien regala la tarjeta.</p>

        <div id="senderFields"></div>

        <div class="step-actions">
          <button class="btn-soft" onclick="goToStep(2)">Anterior</button>
          <button class="btn-main" onclick="onNextFrom3()">Siguiente</button>
        </div>
      </div>
    </section>

    <!-- STEP 4 — DESTINATARIOS -->
    <section class="step" id="step4">
      <div class="step-inner">
        <h2>Destinatarios</h2>
        <p class="step-desc">Ingresa nombre, email y mensaje para cada tarjeta.</p>

        <div id="recipientContainer"></div>

        <div class="step-actions">
          <button class="btn-soft" onclick="goToStep(3)">Anterior</button>
          <button class="btn-main" onclick="onNextFrom4()">Siguiente</button>
        </div>
      </div>
    </section>

    <!-- STEP 5 — FORMATO -->
    <section class="step" id="step5">
      <div class="step-inner">
        <h2>Formato de tarjeta</h2>
        <p class="step-desc">Este formato se aplicará a todas las giftcards.</p>

        <div class="format-container">
          <div class="format-card" data-format="square" onclick="selectFormat(this)">
            <div class="format-thumb square"></div><span>Cuadrada</span>
          </div>
          <div class="format-card" data-format="landscape" onclick="selectFormat(this)">
            <div class="format-thumb landscape"></div><span>Horizontal</span>
          </div>
          <div class="format-card" data-format="portrait" onclick="selectFormat(this)">
            <div class="format-thumb portrait"></div><span>Vertical</span>
          </div>
        </div>

        <div class="step-actions">
          <button class="btn-soft" onclick="goToStep(4)">Anterior</button>
          <button class="btn-main" onclick="onNextFrom5()">Siguiente</button>
        </div>
      </div>
    </section>

    <!-- STEP 6 — IMÁGENES -->
    <section class="step" id="step6">
      <div class="step-inner">
        <h2>Imágenes</h2>
        <p class="step-desc">Elige una imagen para cada giftcard.</p>

        <div id="imageButtonsHolder" class="mb-3"></div>
        <div id="imagesPreviewRow" class="d-flex flex-wrap gap-2"></div>

        <div class="step-actions">
          <button class="btn-soft" onclick="goToStep(5)">Anterior</button>
          <button class="btn-main" onclick="onNextFrom6()">Siguiente</button>
        </div>
      </div>
    </section>

    <!-- STEP 7 — PREVIEW -->
    <section class="step" id="step7">
      <div class="step-inner">
        <h2>Previsualización</h2>
        <p class="step-desc">Así se verán tus tarjetas (con marca de agua).</p>

        <div id="previewArea" class="preview-list"></div>

        <div class="alert alert-info small mt-2 text-center mb-0">
          Las tarjetas serán válidas una vez completado el pago.
        </div>

        <div class="step-actions mt-3">
          <button class="btn-soft" onclick="goToStep(6)">Anterior</button>
          <button class="btn-main" onclick="goToStep(8)">Ir al resumen</button>
        </div>
      </div>
    </section>

    <!-- STEP 8 — PAGO -->
    <section class="step" id="step8">
      <div class="step-inner">
        <h2>Resumen y pago</h2>
        <p class="step-desc">Revisa los datos antes de continuar.</p>

        <div id="checkoutArea" class="checkout-list"></div>

        <div class="step-actions">
          <button class="btn-soft" onclick="goToStep(7)">Anterior</button>
          <button class="btn-main" onclick="proceedToPayment()">Proceder al pago</button>
        </div>
      </div>
    </section>

  </main>
</div>

<!-- MODAL IMÁGENES -->
<div class="modal fade" id="imgModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content" style="position:relative;">

      <!-- 🔵 BOTÓN CERRAR ARRIBA CENTRADO -->
      <button id="closeImgModalBtn"
              class="btn btn-light rounded-circle shadow-sm"
              style="
                position:absolute;
                top:10px;
                left:50%;
                transform:translateX(-50%);
                z-index:10;
              ">
        ✕
      </button>

      <img id="modalMainImg" src="" alt="Vista previa">

      <div id="modalThumbs"
           class="d-flex justify-content-center flex-wrap gap-2 mt-3 px-2">
      </div>

      <button id="confirmImgBtn" class="btn btn-primary mt-3">Usar esta imagen</button>

      <div class="d-flex justify-content-around px-3 pb-3 mt-2">
        <button class="btn" id="prevImg">« Anterior</button>
        <button class="btn" id="nextImg">Siguiente »</button>
      </div>

    </div>
  </div>
</div>


<!-- SPINNER -->
<div id="loadingOverlay">
  <div class="spinner"></div>
  <div class="loading-text">Generando tus tarjetas...</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/qrcode/build/qrcode.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="script.js?v=1"></script>

</body>
</html>
