<?php
require_once __DIR__ . '/../functions.php';
require_once __DIR__ . '/auth.php';

$settings = getSettings();
$business = htmlspecialchars($settings['business_name'] ?? 'Giftcards PRO');

if (!isset($page)) $page = "";
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title><?php echo $business; ?> C Panel Admin</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

  <!-- ICONS -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

  <style>
    body {
      background: #f5f6fa;
      font-family: "Inter", system-ui, sans-serif;
    }

    /* ==============================
       TOP NAV
    ================================= */
    .topbar {
      background: #111827;
      padding: 12px 20px;
      color: #fff;
      display: flex;
      align-items: center;
      justify-content: space-between;
      position: sticky;
      top: 0;
      z-index: 999;
    }

    .topbar .brand {
      font-size: 18px;
      font-weight: 600;
      letter-spacing: .3px;
    }

    /* ==============================
       SIDEBAR
    ================================= */
    .sidebar {
      width: 240px;
      background: #1f2937;
      color: #fff;
      position: fixed;
      top: 56px;
      bottom: 0;
      padding-top: 20px;
    }

    .sidebar a {
      display: block;
      padding: 12px 20px;
      color: #e5e7eb;
      text-decoration: none;
      font-size: 15px;
      transition: 0.2s;
    }

    .sidebar a:hover {
      background: #374151;
      color: #fff;
    }

    .sidebar a.active {
      background: #2563eb;
      color: #fff !important;
      font-weight: 600;
    }

    /* CONTENT */
    .content-wrapper {
      margin-left: 240px;
      padding: 25px;
    }

    @media(max-width: 992px) {
      .sidebar {
        position: fixed;
        width: 100%;
        height: auto;
        top: 56px;
        display: flex;
        overflow-x: auto;
        white-space: nowrap;
      }
      .sidebar a {
        padding: 14px 18px;
        display: inline-block;
      }
      .content-wrapper {
        margin-left: 0;
        margin-top: 90px;
      }
    }
  </style>
</head>

<body>

<!-- ==========================
     TOP NAVBAR
=========================== -->
<div class="topbar">
  <div class="brand">
    <i class="fa-solid fa-gift"></i> <?php echo $business; ?>  Admin
  </div>

  <div>
    <span class="me-3 text-white-50">
      <?php echo htmlspecialchars($_SESSION['user_email'] ?? ''); ?>
    </span>
    <a href="logout.php" class="btn btn-sm btn-outline-light">
      <i class="fa-solid fa-right-from-bracket"></i> Salir
    </a>
  </div>
</div>

<!-- ==========================
     SIDEBAR
=========================== -->
<div class="sidebar">

  <a href="dashboard.php" class="<?php echo ($page=='dashboard')?'active':''; ?>">
    <i class="fa-solid fa-chart-line me-2"></i> Dashboard
  </a>

  <a href="giftcards.php" class="<?php echo ($page=='giftcards')?'active':''; ?>">
    <i class="fa-solid fa-credit-card me-2"></i> Giftcards
  </a>

  <a href="customers.php" class="<?php echo ($page=='customers')?'active':''; ?>">
    <i class="fa-solid fa-users me-2"></i> Clientes
  </a>

  <a href="amounts.php" class="<?php echo ($page=='amounts')?'active':''; ?>">
    <i class="fa-solid fa-coins me-2"></i> Montos
  </a>

  <a href="images.php" class="<?php echo ($page=='images')?'active':''; ?>">
    <i class="fa-solid fa-image me-2"></i> Imgenes
  </a>

  <a href="settings.php" class="<?php echo ($page=='settings')?'active':''; ?>">
    <i class="fa-solid fa-gear me-2"></i> Configuracin
  </a>

</div>

<!-- ==========================
     CONTENT
=========================== -->
<div class="content-wrapper">
