<?php
require_once __DIR__ . '/header.php';
global $pdo;

$search = trim($_GET['q'] ?? '');

$sql = "SELECT * FROM giftcards";
$params = [];
if ($search !== '') {
  $sql .= " WHERE recipient_name LIKE ?
            OR sender_name LIKE ?
            OR code LIKE ?";
  $like = '%' . $search . '%';
  $params = [$like, $like, $like];
}
$sql .= " ORDER BY created_at DESC LIMIT 200";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll();

// BASE URL
$settings = getSettings();
$baseUrl  = rtrim($settings['base_url'] ?? BASE_URL, '/');
?>

<style>
/* -------------------------------------------------------
   ESTILO iOS PREMIUM PARA TABLAS Y PREVIEW
------------------------------------------------------- */
body {
  font-family: -apple-system, BlinkMacSystemFont, "SF Pro Text", system-ui;
}

.ios-card {
  background: #fff;
  border-radius: 22px;
  padding: 18px;
  box-shadow: 0 10px 28px rgba(15,23,42,0.08);
  border: 1px solid rgba(0,0,0,0.04);
}

.table-ios thead th {
  border-bottom: 2px solid #f1f1f4 !important;
  font-size: 13px;
  text-transform: uppercase;
  letter-spacing: .04em;
  color: #6b7280;
}

.table-ios tbody td {
  padding-top: 14px !important;
  padding-bottom: 14px !important;
  font-size: 14px;
}

.thumbnail-ios {
  width: 110px;
  height: 70px;
  object-fit: cover;
  border-radius: 14px;
  cursor: pointer;
  transition: transform .18s;
  box-shadow: 0 8px 20px rgba(0,0,0,0.08);
}

.thumbnail-ios:hover {
  transform: scale(1.03);
}

/* Modal estilo iOS */
.modal-content-ios {
  border-radius: 30px;
  background: #fff;
  overflow: hidden;
  padding: 0;
  border: none;
  -webkit-mask-image: -webkit-radial-gradient(white, black);
}

.modal-full-img {
  width: 100%;
  height: auto;
  display: block;
}

.btn-pill-soft {
  border-radius: 999px;
  padding: 10px 18px;
  background: #f2f3f5;
  border: 1px solid #d1d5db;
  font-size: 14px;
  font-weight: 500;
}

.btn-pill-main {
  border-radius: 999px;
  padding: 10px 18px;
  background: #007aff;
  border: none;
  color: #fff;
  font-size: 15px;
  font-weight: 600;
}
</style>

<h1 class="h4 mb-4" style="font-weight:700;">Giftcards vendidas</h1>

<div class="ios-card mb-4">
  <form class="row g-2">
    <div class="col-md-5">
      <input type="text" name="q" value="<?php echo htmlspecialchars($search); ?>" 
             class="form-control form-control-lg" 
             placeholder="Buscar por nombre, remitente o cdigo">
    </div>
    <div class="col-md-2">
      <button class="btn btn-pill-main w-100">Buscar</button>
    </div>
  </form>
</div>

<div class="ios-card">
  <div class="table-responsive">
    <table class="table table-hover align-middle table-ios">
      <thead>
        <tr>
          <th>Giftcard</th>
          <th>Fecha</th>
          <th>Para</th>
          <th>Contacto</th>
          <th>De</th>
          <th>Email</th>
          <th>Monto</th>
          <th>Cdigo</th>
          <th>Estado</th>
          <th>Batch</th>
        </tr>
      </thead>
      <tbody>

      <?php foreach ($rows as $g): ?>
        <?php
        // Miniatura de la tarjeta
        $imgFile = $g['image_filename'] ?: null;
        $thumb = $imgFile 
          ? "{$baseUrl}/giftcards/{$imgFile}" 
          : "{$baseUrl}/logo/logo.png";
        ?>
        <tr>
          <td>
            <?php if ($imgFile): ?>
              <img src="<?php echo $thumb; ?>" 
                   class="thumbnail-ios" 
                   onclick="openPreview('<?php echo $thumb; ?>')">
            <?php else: ?>
              <span class="text-muted small">Sin imagen</span>
            <?php endif; ?>
          </td>

          <td><?php echo htmlspecialchars($g['created_at']); ?></td>
          <td><?php echo htmlspecialchars($g['recipient_name']); ?></td>
          <td><?php echo htmlspecialchars($g['recipient_contact']); ?></td>
          <td><?php echo htmlspecialchars($g['sender_name']); ?></td>
          <td><?php echo htmlspecialchars($g['sender_email']); ?></td>
          <td>$<?php echo number_format($g['amount'],2); ?></td>
          <td><?php echo htmlspecialchars($g['code']); ?></td>
          <td>
            <span class="badge bg-<?php echo ((int)$g['is_valid'] === 1) ? 'success' : 'danger'; ?>">
              <?php echo ((int)$g['is_valid'] === 1) ? 'Vlida' : 'No vlida'; ?>
            </span>
          </td>
          <td><?php echo htmlspecialchars($g['purchase_token']); ?></td>
        </tr>
      <?php endforeach; ?>

      </tbody>
    </table>
  </div>
</div>


<!-- ============================
     MODAL PREMIUM iOS
============================= -->
<div class="modal fade" id="previewModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content modal-content-ios">
      <img id="previewImage" class="modal-full-img">
      <div class="p-3 text-center">
        <button class="btn btn-pill-soft me-2" data-bs-dismiss="modal">Cerrar</button>
        <a id="downloadBtn" class="btn btn-pill-main" download>Descargar</a>
      </div>
    </div>
  </div>
</div>

<script>
function openPreview(imgUrl) {
  document.getElementById("previewImage").src = imgUrl + "?v=" + Date.now();
  document.getElementById("downloadBtn").href = imgUrl;

  const modal = new bootstrap.Modal(document.getElementById('previewModal'));
  modal.show();
}
</script>

<?php require_once __DIR__ . '/footer.php'; ?>
