<?php
require_once __DIR__ . '/header.php';
global $pdo;

$stmt = $pdo->query("SELECT * FROM customers ORDER BY created_at DESC");
$customers = $stmt->fetchAll();
?>
<h1 class="h4 mb-3">Clientes y puntos</h1>

<div class="table-responsive">
  <table class="table table-sm table-hover">
    <thead>
      <tr>
        <th>Email</th>
        <th>Nombre</th>
        <th>Total gastado</th>
        <th>Puntos</th>
        <th>Creado</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($customers as $c): ?>
        <tr>
          <td><?php echo htmlspecialchars($c['email']); ?></td>
          <td><?php echo htmlspecialchars($c['name']); ?></td>
          <td>$<?php echo number_format($c['total_spent'],2); ?></td>
          <td><?php echo (int)$c['points_balance']; ?></td>
          <td><?php echo htmlspecialchars($c['created_at']); ?></td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>

<?php require_once __DIR__ . '/footer.php'; ?>
